<?php
/**
 * Tags
 *
 * @package     AutomatorWP\BuddyBoss\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Donation tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_give_get_donation_tags() {

    return array(
        'donation_id' => array(
            'label'     => __( 'Donation ID', 'automatorwp-buddyboss' ),
            'type'      => 'integer',
            'preview'   => '1',
        ),
        'donation_total' => array(
            'label'     => __( 'Donation total', 'automatorwp-buddyboss' ),
            'type'      => 'text',
            'preview'   => '100',
        ),
        'donor_id' => array(
            'label'     => __( 'Donor ID', 'automatorwp-buddyboss' ),
            'type'      => 'integer',
            'preview'   => '1',
        ),
        'donor_email' => array(
            'label'     => __( 'Donor email', 'automatorwp-buddyboss' ),
            'type'      => 'text',
            'preview'   => 'contact@automatorwp.com',
        ),
        'donation_form_id' => array(
            'label'     => __( 'Form ID', 'automatorwp-buddyboss' ),
            'type'      => 'text',
            'preview'   => '123',
        ),
        'donation_form_title' => array(
            'label'     => __( 'Form title', 'automatorwp-buddyboss' ),
            'type'      => 'text',
            'preview'   => 'Donation form',
        ),
    );

}

/**
 * Custom trigger donation tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_give_get_trigger_donation_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'give' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'donation_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'donation_id', true );
            break;
        case 'donation_total':
            $replacement = automatorwp_get_log_meta( $log->id, 'donation_total', true );
            break;
        case 'donor_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'donor_id', true );
            break;
        case 'donor_email':
            $replacement = automatorwp_get_log_meta( $log->id, 'donor_email', true );
            break;
        case 'donation_form_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'donation_form_id', true );
            break;
        case 'donation_form_title':
            $replacement = automatorwp_get_log_meta( $log->id, 'donation_form_title', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_give_get_trigger_donation_tag_replacement', 10, 6 );